<?php 
session_start();

include("../../../sql_connect.php");
include("functions.php");

$user_data = check_login($dbc);
?>

<!DOCTYPE html>
<html lang="en">
<?php require("assets/includes/head.html") ?>
</head>
<title>Create - Warpon Prime</title>
<?php include("assets/includes/header.php"); ?>

<main>
    <form method="post" action="create_warframe.php">
        <div class="buildTitle">
            <h1 class="warpTitle">Create Your Warframe</h1>
        </div>

        <div class="newBuildStats">
            <label>Warframe Name: <input type="text" name="name" required></label><br>
            <label>Description: <textarea name="description" required></textarea></label><br>
            <label>Image URL: <input type="url" name="image_link"></label><br>

            <h3>Abilities</h3>
            <label>Strength: <input type="number" name="strength" min="0" max="500" required>%</label><br>
            <label>Duration: <input type="number" name="duration" min="0" max="500" required>%</label><br>
            <label>Efficiency: <input type="number" name="efficiency" min="0" max="500" required>%</label><br>
            <label>Range: <input type="number" name="range" min="0" max="500" required>%</label><br>

            <h3>Stats</h3>
            <label>Health: <input type="number" name="health" required></label><br>
            <label>Shield: <input type="number" name="shield" required></label><br>
            <label>Armor: <input type="number" name="armor" required></label><br>
            <label>Energy: <input type="number" name="energy" required></label><br>

            <h3>Additional</h3>
            <label>Gender: 
                <input type="text" name="gender" required>
            </label><br>
            <label>Sprint Speed: <input type="number" step="0.01" name="sprint" required></label><br>
            <label>Release Date: <input type="date" name="release_date"></label><br>
            <label>Release Order of Type: <input type="number" name="release_order" required></label><br>
            <label>Mastery Requirement: <input type="number" name="mastery" required></label><br>

            <input type="hidden" name="creator" value="<?php echo htmlspecialchars($user_data['USERNAME']); ?>">

            <button type="submit" class="likeBtn">Create Warframe</button>
        </div>
    </form>
</main>

<?php include("assets/includes/footer.html"); ?>
</body>
</html>
